#include <AccelStepper.h>

const int pinStep = 3;
const int pinDir = 2;
const int pinReset = 4;

int numSteps = 100;

AccelStepper stepper(1, pinStep, pinDir);  // driver

int accel = 20;                       // aceleración
int velmax = 400;                    // velocidad en pasos x segundo

void setup() { 

  pinMode(pinReset, OUTPUT);
  digitalWrite(pinReset, HIGH);

  stepper.setAcceleration(accel);
  stepper.setMaxSpeed(velmax);      // velocidad máxima del motor stepper (aceleración)
  
}

void loop() {
 
  stepper.moveTo(numSteps);
  stepper.runToPosition();
  delay(1000);
  
  stepper.moveTo(-numSteps);
  stepper.runToPosition();
  delay(1000);
  
}
