int pins[] = {8, 9, 10, 11};  // Motor pins
int npins = 4;

int nsteps = 8;

// Full-step (wave drive)
int steps[8][4] = {
  {1, 0, 0, 0},
  {0, 1, 0, 0},
  {0, 0, 1, 0},
  {0, 0, 0, 1},
  {1, 0, 0, 0},
  {0, 1, 0, 0},
  {0, 0, 1, 0},
  {0, 0, 0, 1}
};

int n = 0;
unsigned long delaystep = 100;
unsigned long reftime = millis();

int pinPote = A5;
int valPote;
int pinInterrupt = 2;

int interruptsRev = 1;    // Número interrupciones por cada rotación completa

float rpmMax = 600;
float rpm = 0;

volatile unsigned long reftimeT = millis();       // Modificado en la interrupción
volatile unsigned long T = 1;                     // T es el tiempo entre interrupciones -> Modificado en la interrupción
                                                  // (T * interruptsRev) es el período de rotación 

unsigned long reftimePrint = millis();
unsigned long intervalPrint = 250;

void setup() {

  Serial.begin(9600);
  
  for (int i = 0; i < npins; i++) {
    pinMode(pins[i], OUTPUT);
    digitalWrite(pins[i], LOW);
  }

  pinMode(pinInterrupt, INPUT);

  // attachInterrupt(digitalPinToInterrupt(pinInterrupt), detectarEvento, RISING);  // Interrupción 0: Pin 2 Arduino Uno, Pin 3 Arduino Leonardo
  attachInterrupt(digitalPinToInterrupt(pinInterrupt), detectarEvento, FALLING);
  //  attachInterrupt(digitalPinToInterrupt(pinInterrupt), detectarEvento, CHANGE);
  //  attachInterrupt(digitalPinToInterrupt(pinInterrupt), detectarEvento, LOW);
  
}

void loop() {

  valPote = analogRead(pinPote);
  delaystep = map(valPote,0,1023,10,3);

  if (millis()-reftime >= delaystep) {
    stepMotor(n);
    n++;
    if (n >= nsteps) {
      n = 0;
    }
    reftime = millis();   
  }

  if (millis() - reftimePrint >= intervalPrint) {
    rpm = 60000.0 / (T * interruptsRev);
    if (rpm < rpmMax) {
      Serial.print("RPM: ");
      Serial.println(rpm);
    }
    reftimePrint = millis();
  }

}

void stepMotor(int s) {
  for (int i = 0; i < npins; i++) {
    digitalWrite(pins[i], steps[s][i]);
  }
}

void detectarEvento() {
  unsigned long now = millis();
  T = now - reftimeT;
  reftimeT = now;
}
